package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TramiteAperturasDaoImpl;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TramiteAperturasDaoImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TramiteAperturasCustomDaoImpl extends TramiteAperturasDaoImpl
		implements TramiteAperturasCustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TRAMITE_062 IDTRAMITE062, t1.TIPO_TRAMITE_062 TIPOTRAMITE062, t1.TERRIT_APERTURA_062 TERRITAPERTURA062, t1.ANO_APERTURA_062 ANOAPERTURA062, t1.NUM_APERTURA_062 NUMAPERTURA062, t1.PROCEDURE_ID_089 PROCEDUREID089, t1.PROCEEDING_ID_089 PROCEEDINGID089, t1.DESCRIPCION_ES_089 DESCRIPCIONES089, t1.DESCRIPCION_EU_089 DESCRIPCIONEU089 FROM VTRAMITES_APERTURAS t1 ";

	private static final String QUERY_SELECT_2 = "SELECT t1.ID_TRAMITE_062 IDTRAMITE062,  t1.TIPO_TRAMITE_062 TIPOTRAMITE062,  t1.TERRIT_APERTURA_062 TERRITAPERTURA062,  t1.ANO_APERTURA_062 ANOAPERTURA062,  t1.NUM_APERTURA_062 NUMAPERTURA062,  t1.PROCEEDING_ID_089 PROCEEDINGID089,  J.FECPRE_056 FECHAPRESENTACION056  FROM VTRAMITES_APERTURAS t1 LEFT JOIN AB0456T00 J ON t1.TERRIT_APERTURA_062 = J.TERAPE_056 AND t1.ANO_APERTURA_062   = J.ANOAPE_056 AND t1.NUM_APERTURA_062   = J.NUMAPE_056 ";
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TramiteAperturas> rwMap = new RowMapper<TramiteAperturas>() {
		public TramiteAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TramiteAperturas tram = new TramiteAperturas(
					resultSet.getLong("IDTRAMITE062"), null, null);

			tram.setApertura(new ComunicacionApertura(resultSet
					.getString("TERRITAPERTURA062"), resultSet
					.getString("ANOAPERTURA062"), resultSet
					.getLong("NUMAPERTURA062")));

			tram.setTipoTramite(new Tramite(
					resultSet.getLong("TIPOTRAMITE062"), resultSet
							.getString("PROCEDUREID089"), resultSet
							.getString("PROCEEDINGID089"), resultSet
							.getString("DESCRIPCIONES089"), resultSet
							.getString("DESCRIPCIONEU089")));

			return tram;
		}
	};

	private RowMapper<TramiteAperturas> rwMapDoc = new RowMapper<TramiteAperturas>() {
		public TramiteAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TramiteAperturas tram = new TramiteAperturas(
					resultSet.getLong("IDTRAMITE062"), null, null);

			ComunicacionApertura comAper = new ComunicacionApertura(
					resultSet.getString("TERRITAPERTURA062"),
					resultSet.getString("ANOAPERTURA062"),
					resultSet.getLong("NUMAPERTURA062"));
			comAper.setFecpre056(resultSet.getDate("FECHAPRESENTACION056"));
			tram.setApertura(comAper);

			Tramite tramite = new Tramite();
			tramite.setProceedingId089(resultSet.getString("PROCEEDINGID089"));
			tram.setTipoTramite(tramite);

			return tram;
		}
	};

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	@Transactional(readOnly = true)
	public TramiteAperturas vfind(TramiteAperturas tramiteAperturas) {
		StringBuilder query = new StringBuilder(
				TramiteAperturasCustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TRAMITE_062 = ? ");

		List<TramiteAperturas> tramiteAperturasList = this.getJdbcTemplate()
				.query(query.toString(), this.rwMap,
						tramiteAperturas.getIdTramite062());
		return (TramiteAperturas) DataAccessUtils
				.uniqueResult(tramiteAperturasList);
	}

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  apertura
	 *            ComunicacionApertura
	 *  TramiteAperturas
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param apertura the apertura
	 * @return the tramite aperturas
	 */
	@Transactional(readOnly = true)
	public TramiteAperturas findLastTramiteByTipo(Long idTipoTramite,
			ComunicacionApertura apertura) {
		StringBuilder query = new StringBuilder(
				TramiteAperturasCustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.TIPO_TRAMITE_062 = ? AND t1.TERRIT_APERTURA_062 = ? AND ANO_APERTURA_062 = ? AND NUM_APERTURA_062 = ? ");
		query.append(" ORDER BY t1.ID_TRAMITE_062 DESC ");

		List<TramiteAperturas> tramiteAperturasList = this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, idTipoTramite,
						apertura.getTerape056(), apertura.getAnoape056(),
						apertura.getNumape056());

		if (tramiteAperturasList == null || tramiteAperturasList.isEmpty()) {
			return null;
		}
		return tramiteAperturasList.get(0);
	}

	/**
	 * Finds a list of rows in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TramiteAperturas>
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TramiteAperturas> vfindAll(TramiteAperturas tramiteAperturas,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TramiteAperturasCustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramiteAperturas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TramiteAperturas>) this.getJdbcTemplate().query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteAperturas entity
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TramiteAperturas tramiteAperturas) {

		StringBuilder where = new StringBuilder(
				TramiteAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramiteAperturas != null
				&& tramiteAperturas.getIdTramite062() != null) {
			where.append(" AND t1.ID_TRAMITE_062 = ?");
			params.add(tramiteAperturas.getIdTramite062());
		}
		if (tramiteAperturas != null
				&& tramiteAperturas.getTipoTramite() != null
				&& tramiteAperturas.getTipoTramite().getIdTramite089() != null) {
			where.append(" AND t1.TIPO_TRAMITE_062 = ?");
			params.add(tramiteAperturas.getTipoTramite().getIdTramite089());
		}
		if (tramiteAperturas != null && tramiteAperturas.getApertura() != null
				&& tramiteAperturas.getApertura().getTerape056() != null) {
			where.append(" AND t1.TERRIT_APERTURA_062 = ?");
			params.add(tramiteAperturas.getApertura().getTerape056());
		}
		if (tramiteAperturas != null && tramiteAperturas.getApertura() != null
				&& tramiteAperturas.getApertura().getAnoape056() != null) {
			where.append(" AND t1.ANO_APERTURA_062 = ?");
			params.add(tramiteAperturas.getApertura().getAnoape056());
		}
		if (tramiteAperturas != null && tramiteAperturas.getApertura() != null
				&& tramiteAperturas.getApertura().getNumape056() != null) {
			where.append(" AND t1.NUM_APERTURA_062 = ?");
			params.add(tramiteAperturas.getApertura().getNumape056());
		}

		if (tramiteAperturas != null
				&& tramiteAperturas.getTipoTramite() != null
				&& tramiteAperturas.getTipoTramite().getIdTramite089() != null) {
			where.append(" AND t1.TIPO_TRAMITE_062 = ?");
			params.add(tramiteAperturas.getTipoTramite().getIdTramite089());
		}
		if (tramiteAperturas != null
				&& tramiteAperturas.getTipoTramite() != null
				&& tramiteAperturas.getTipoTramite().getProcedureId089() != null) {
			where.append(" AND t1.PROCEDURE_ID_089 = ?");
			params.add(tramiteAperturas.getTipoTramite().getProcedureId089());
		}
		if (tramiteAperturas != null
				&& tramiteAperturas.getTipoTramite() != null
				&& tramiteAperturas.getTipoTramite().getProceedingId089() != null) {
			where.append(" AND t1.PROCEEDING_ID_089 = ?");
			params.add(tramiteAperturas.getTipoTramite().getProceedingId089());
		}
		if (tramiteAperturas != null
				&& tramiteAperturas.getTipoTramite() != null
				&& tramiteAperturas.getTipoTramite().getDescripcionEs089() != null) {
			where.append(" AND t1.DESCRIPCION_ES_089 = ?");
			params.add(tramiteAperturas.getTipoTramite().getDescripcionEs089());
		}
		if (tramiteAperturas != null
				&& tramiteAperturas.getTipoTramite() != null
				&& tramiteAperturas.getTipoTramite().getDescripcionEu089() != null) {
			where.append(" AND t1.DESCRIPCION_EU_089 = ?");
			params.add(tramiteAperturas.getTipoTramite().getDescripcionEu089());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/* (non-Javadoc)
	 * @see com.ejie.ab04b.dao.custom.TramiteAperturasCustomDao#findAllImprimirDocsAperturaLike(com.ejie.ab04b.model.TramiteAperturas, com.ejie.x38.dto.JQGridRequestDto, boolean)
	 */
	public List<TramiteAperturas> findAllImprimirDocsAperturaLike(
			TramiteAperturas filterTramiteAperturas,
			JQGridRequestDto jqGridRequestDto, boolean b) {
		StringBuilder query = new StringBuilder(
				TramiteAperturasCustomDaoImpl.QUERY_SELECT_2);

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereDocumentoMap(filterTramiteAperturas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TramiteAperturas>) this.getJdbcTemplate().query(
				query.toString(), this.rwMapDoc, params.toArray());
	}

	/* (non-Javadoc)
	 * @see com.ejie.ab04b.dao.custom.TramiteAperturasCustomDao#findAllLikeImprimirDocsAperturaCount(com.ejie.ab04b.model.TramiteAperturas, boolean)
	 */
	public Long findAllLikeImprimirDocsAperturaCount(
			TramiteAperturas tramiteAperturas, boolean b) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VTRAMITES_APERTURAS t1 LEFT JOIN AB0456T00 J ON t1.TERRIT_APERTURA_062 = J.TERAPE_056 AND t1.ANO_APERTURA_062 = J.ANOAPE_056 AND t1.NUM_APERTURA_062 = J.NUMAPE_056  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereDocumentoMap(tramiteAperturas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Gets the where documento map.
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the where documento map
	 */
	private Map<String, ?> getWhereDocumentoMap(
			TramiteAperturas tramiteAperturas) {

		StringBuilder where = new StringBuilder(
				TramiteAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramiteAperturas != null && tramiteAperturas.getApertura() != null
				&& tramiteAperturas.getApertura().getTerape056() != null) {
			where.append(" AND t1.TERRIT_APERTURA_062 = ?");
			params.add(tramiteAperturas.getApertura().getTerape056());
		}
		if (tramiteAperturas != null && tramiteAperturas.getApertura() != null
				&& tramiteAperturas.getApertura().getAnoape056() != null) {
			where.append(" AND t1.ANO_APERTURA_062 = ?");
			params.add(tramiteAperturas.getApertura().getAnoape056());
		}
		if (tramiteAperturas != null && tramiteAperturas.getApertura() != null
				&& tramiteAperturas.getApertura().getNumExpDesde() != null) {
			where.append(" AND t1.NUM_APERTURA_062 >= ? ");
			params.add(tramiteAperturas.getApertura().getNumExpDesde());
		}

		if (tramiteAperturas != null && tramiteAperturas.getApertura() != null
				&& tramiteAperturas.getApertura().getNumExpHasta() != null) {
			where.append(" AND t1.NUM_APERTURA_062 <= ?");
			params.add(tramiteAperturas.getApertura().getNumExpHasta());
		}

		if (tramiteAperturas != null
				&& tramiteAperturas.getTipoTramite() != null
				&& tramiteAperturas.getTipoTramite().getProceedingId089() != null) {
			where.append(" AND t1.PROCEEDING_ID_089 = ?");
			params.add(tramiteAperturas.getTipoTramite().getProceedingId089());
		}

		if (tramiteAperturas != null && tramiteAperturas.getApertura() != null
				&& tramiteAperturas.getApertura().getFecpreDesde() != null) {
			where.append(" AND J.FECPRE_056 >= ? ");
			params.add(tramiteAperturas.getApertura().getFecpreDesde());
		}

		if (tramiteAperturas != null && tramiteAperturas.getApertura() != null
				&& tramiteAperturas.getApertura().getFecpreHasta() != null) {
			where.append(" AND J.FECPRE_056 <= ?");
			params.add(tramiteAperturas.getApertura().getFecpreHasta());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

}
